<?php

/**
 * Smarty plugin
 *
 * @package    com.pcsg.pms.smarty
 * @subpackage plugins
 */

/**
 * Smarty {plugin_files} function plugin
 * Fügt Pluginfiles in den Header
 *
 *
 * Type:     function<br>
 * Name:     sibling<br>
 *
 * @param array $params parameters
 * @param Smarty $Smarty
 *
 * @return null
 * @author PCSG
 */
function smarty_function_sibling($params, $Smarty)
{
    $type = 'next';

    if (isset($params['type'])) {
        switch ($params['type']) {
            default:
                $type = 'next';
                break;

            case 'prev':
            case 'previous':
                $type = 'previous';
                break;
        }
    }

    if (!isset($params['site'])) {
        return null;
    }

    try {
        switch ($type) {
            case 'next':
                $Sibling = $params['site']->nextSibling();
                break;

            case 'previous':
                $Sibling = $params['site']->previousSibling();
                break;

            default:
                $Sibling = false;
        }

        $Smarty->assign($params['assign'], $Sibling);
    } catch (Exception) {
        $Smarty->assign($params['assign'], false);
    }

    return null;
}
