<?php

/**
 * Smarty plugin
 *
 * @package    com.pcsg.pms.smarty
 * @subpackage plugins
 */

use QUI\Exception;
use QUI\Projects\Manager;
use QUI\Projects\Project;

/**
 * Smarty {suffix} function plugin
 *
 * Type:     function<br>
 * Name:     url<br>
 *
 * @param array $params parameters
 * @param Smarty $smarty
 *
 * @return string|null
 * @throws Exception
 * @author PCSG
 *
 */
function smarty_function_suffix($params, &$smarty)
{
    global $Project;

    if (!isset($params['suffix'])) {
        return '';
    }

    $P = $Project;

    /* @var $Project Project */

    $url = '';
    $site = false;

    try {
        if (isset($params['site'])) {
            $site = $params['site'];
        } elseif (isset($params['id'])) {
            if (isset($params['lang'])) {
                $P = Manager::getProject(
                    $Project->getAttribute('name'),
                    $params['lang']
                );
            }

            $site = $P->get((int)$params['id']);
        }
    } catch (Exception) {
        return '';
    }

    unset($params['site']);
    unset($params['id']);
    unset($params['lang']);

    $url = '';

    if ($site && $site->getId()) {
        $url = $site->getUrl($params);
    }

    return $url;
}
