<?php

/**
 * Smarty plugin
 *
 * @package    com.pcsg.pms.smarty
 * @subpackage plugins
 */


/**
 * Smarty {t}Text{/t} block plugin
 * - Translation eines Textest im Template
 *
 * @param array<string, mixed> $params
 * @param string|null $content - contents of the block
 * @param Smarty | Smarty_Internal_Template $Smarty
 * @return string
 */
function smarty_block_t(array $params, ?string $content, Smarty | Smarty_Internal_Template $Smarty): string
{
    if ($content === null) {
        return '';
    }

    $_param = explode(' ', $content);

    if (str_contains($_param[0], '/') && !str_contains($_param[1], ' ')) {
        $result = QUI::getLocale()->get($_param[0], $_param[1], $params);

        if (empty($result)) {
            return $content;
        }

        return $result;
    }

    global $Site;

    if (!isset($Site)) {
        return $content;
    }

    return '';
}
