<?php

/**
 * Smarty Plugin
 *
 * @package    com.pcsg.pms.smarty
 * @subpackage plugins
 *
 * @author     PCSG - Henning
 */

use QUI\Utils\Text\BBCode;

/**
 * Smarty {url} function plugin
 *
 * @param array<string, mixed> $params - parameters
 * @param Smarty | Smarty_Internal_Template $Smarty
 * @return string
 */
function smarty_function_bbcode(array $params, Smarty | Smarty_Internal_Template $Smarty): string
{
    if (!isset($params['value'])) {
        return '';
    }

    $BBCode = new BBCode();
    $str = $BBCode->parseToHTML($params['value']);

    if (isset($params['innerHTML'])) {
        $inner = preg_replace('#<a([^>]*)>(.*?)<\/a>#is', "$2", $str) ?? '';
        $inner_html = str_replace('%value', $inner, (string)$params['innerHTML']);
        $str = preg_replace('#<a([^>]*)>(.*?)<\/a>#is', "<a$1>$inner_html</a>", $str) ?? '';
    }

    if (isset($params['assign'])) {
        $Smarty->assign($params['assign'], $str);
    }

    return $str;
}
