<?php

/**
 * Smarty Plugin
 *
 * @package    com.pcsg.pms.smarty
 * @subpackage plugins
 *
 * @author     PCSG - Henning
 */


/**
 * Smarty {json_decode} function plugin
 *
 * @param array<string, mixed> $params
 * @param Smarty | Smarty_Internal_Template $Smarty
 * @return string|null
 */
function smarty_function_json_encode(array $params, Smarty | Smarty_Internal_Template $Smarty): string | false | null
{
    if (!isset($params['var'])) {
        return null;
    }

    $arr = json_encode($params['var']);

    if (!isset($params['assign'])) {
        return $arr;
    }

    $Smarty->assign($params['assign'], $arr);
    return null;
}
