<?php

/**
 * Smarty plugin
 *
 * @package    Smarty
 * @subpackage plugins
 */


/**
 * Smarty {user id=user_id} function plugin
 *
 * @param array<string, mixed> $params
 * @param Smarty | Smarty_Internal_Template $Smarty
 */
function smarty_function_user(array $params, Smarty | Smarty_Internal_Template $Smarty): void
{
    if (empty($params['id'])) {
        $Smarty->assign($params['var'], QUI::getUsers()->getNobody());
        return;
    }

    try {
        $User = QUI::getUsers()->get($params['id']);
    } catch (QUI\Exception) {
        $User = QUI::getUsers()->getNobody();
    }

    $Smarty->assign($params['var'], $User);
}
