<?php

/**
 * Smarty plugin
 * @package Smarty
 * @subpackage plugins
 */


/**
 * Smarty {explode var= delimiter= assign=} function plugin
 *
 * @param array<string, mixed> $params
 * @param Smarty | Smarty_Internal_Template $Smarty
 * @return array<int, string>|null
 */
function smarty_function_explode(array $params, Smarty | Smarty_Internal_Template $Smarty): ?array
{
    if (!isset($params['var'])) {
        return null;
    }

    if (!isset($params['delimiter'])) {
        return null;
    }

    $result = explode($params['delimiter'], $params['var']);

    foreach ($result as $key => $value) {
        if (empty($value)) {
            unset($result[$key]);
        }
    }

    if (!isset($params['assign'])) {
        return $result;
    }

    $Smarty->assign($params['assign'], $result);
    return null;
}
