<?php

/**
 * Smarty plugin
 *
 * @package    com.pcsg.pms.smarty
 * @subpackage plugins
 */


/**
 * Smarty {array} function plugin
 * - an array in a Smarty template
 *
 * @param array<string, mixed> $params parameters
 * @param Smarty | Smarty_Internal_Template $smarty Smarty object
 */
function smarty_function_array(array $params, Smarty | Smarty_Internal_Template $smarty): void
{
    if (!isset($params['var'])) {
        return;
    }

    $var = $params['var'];
    $arr = [];

    unset($params['var']);

    foreach ($params as $key => $value) {
        $arr[$key] = $value;
    }

    $smarty->assign($var, $arr);
}
