<?php

/**
 * Smarty plugin
 *
 * @package    com.pcsg.pms.smarty
 * @subpackage plugins
 */


/**
 * Smarty {array_unset var=$array key=1 assign=} function plugin
 *
 * @param array<string, mixed> $params - parameters
 * @param Smarty | Smarty_Internal_Template $Smarty - Smarty object
 */
function smarty_function_array_unset(array $params, Smarty | Smarty_Internal_Template $Smarty): void
{
    if (!isset($params['var'])) {
        return;
    }

    if (!isset($params['assign'])) {
        return;
    }

    $array = $params['var'];
    $key = $params['key'];

    if (isset($array[$key])) {
        unset($array[$key]);
    }

    $Smarty->assign($params['assign'], $array);
}
