<?php

/**
 * Smarty plugin
 *
 * @package    Smarty
 * @subpackage plugins
 */


/**
 * Smarty {include_css file.0="" file.1="" cache="" urlcache=""} function plugin
 *
 * @param array<string, mixed> $params params
 * @param Smarty | Smarty_Internal_Template $smarty
 * @return string
 */
function smarty_function_include_css(array $params, Smarty | Smarty_Internal_Template &$smarty): string
{
    if (!isset($params['cache']) || !isset($params['urlcache'])) {
        return '';
    }

    if (file_exists($params['cache'])) {
        return '<link rel="StyleSheet"  type="text/css" href="' . $params['urlcache'] . '" media="screen" />';
    }

    $css = '';
    $i = 0;

    while ($params['file' . $i]) {
        if (file_exists($params['file' . $i])) {
            $c = file_get_contents($params['file' . $i]) ?: '';
            $css .= str_replace(["\r\n", "\n", "\r"], ' ', $c);
        }

        $i++;
    }

    file_put_contents($params['cache'], $css);

    return '<link rel="StyleSheet"  type="text/css" href="' . $params['urlcache'] . '" media="screen" />';
}
