<?php

/**
 * Smarty Plugin
 *
 * @package    com.pcsg.pms.smarty
 * @subpackage plugins
 *
 * @author     PCSG - Henning
 */


/**
 * Smarty {json_decode} function plugin
 *
 * @param array<string, mixed> $params
 * @param Smarty | Smarty_Internal_Template $Smarty
 * @return array<int|string, mixed>|null
 */
function smarty_function_json_decode(array $params, Smarty | Smarty_Internal_Template $Smarty): mixed
{
    if (!isset($params['var'])) {
        return null;
    }

    if (!isset($params['array'])) {
        $arr = json_decode($params['var']);
    } else {
        $arr = json_decode($params['var'], true);
    }

    if (isset($params['assign'])) {
        $Smarty->assign($params['assign'], $arr);
        return null;
    }

    return $arr;
}
