<?php

/**
 * Smarty plugin
 *
 * @package    com.pcsg.pms.smarty
 * @subpackage plugins
 */


/**
 * Global date format
 *
 * @param array<string, mixed> $params
 * @param Smarty | Smarty_Internal_Template $Smarty
 * @return string
 */
function smarty_function_locale_date(array $params, Smarty | Smarty_Internal_Template $Smarty): string
{
    if (!isset($params['timestamp']) && !isset($params['date'])) {
        return '';
    }

    $timestamp = false;

    if (isset($params['date'])) {
        $timestamp = strtotime($params['date']);
    }

    if (isset($params['timestamp'])) {
        $timestamp = (int)$params['timestamp'];
    }

    if (!$timestamp) {
        return '';
    }


    $format = false;

    if (isset($params['format'])) {
        $format = $params['format'];
    }

    $result = QUI::getLocale()->formatDate($timestamp, $format);

    if (!isset($params['assign'])) {
        return $result;
    }

    $Smarty->assign($params['assign'], $result);

    return '';
}
