<?php

/**
 * Smarty plugin
 *
 * @package    com.pcsg.pms.smarty
 * @subpackage plugins
 */

use QUI\System\Log;

/**
 * Smarty {object} function plugin
 *
 * @param array<string, mixed> $params parameters
 * @param Smarty | Smarty_Internal_Template $Smarty
 * @return string|object
 *
 * @example {object class="\My\Namespace" assign=Obj}
 */
function smarty_function_object(array $params, Smarty | Smarty_Internal_Template $Smarty): string | object
{
    if (!isset($params['class'])) {
        return '';
    }

    $assign = $params['assign'] ?? false;
    $class = $params['class'];

    unset($params['class']);
    unset($params['assign']);

    if (!count($params)) {
        $Object = new $class();
    } else {
        try {
            $Reflection = new ReflectionClass($class);
            $Object = $Reflection->newInstanceArgs($params);
        } catch (Exception $Exception) {
            Log::writeException($Exception);

            return '';
        }
    }

    if (!$assign) {
        return $Object;
    }

    $Smarty->assign($assign, $Object);

    return '';
}
