<?php

/**
 * Smarty Plugin
 *
 * @package    com.pcsg.pms.smarty
 * @subpackage plugins
 *
 * @author     PCSG - Henning
 */


/**
 * Smarty {sentence} function plugin
 *
 * @param array<string, mixed> $params parameters
 * @param Smarty | Smarty_Internal_Template $smarty
 * @return string
 */
function smarty_function_sentence(array $params, Smarty | Smarty_Internal_Template $smarty): string
{
    if (!isset($params['text'])) {
        return '';
    }

    $text = $params['text'];

    if (
        !str_contains($text, '.')
        && !str_contains($text, '!')
        && !str_contains($text, '?')
    ) {
        return '';
    }

    $text = preg_replace('/(.*?[^\.|\!|\?][\.|\!|\?])(.*?)$/', '$1', $text);

    if (!isset($params['assign'])) {
        return $text;
    }

    $smarty->assign($params['assign'], $text);
    return '';
}
