<?php

/**
 * Smarty plugin
 *
 * @package    com.pcsg.pms.smarty
 * @subpackage plugins
 */


/**
 * Smarty {plugin_files} function plugin
 * Add Plugin files to the header
 *
 * @param array<string, mixed> $params parameters
 * @param Smarty | Smarty_Internal_Template $Smarty
 * @return null
 */
function smarty_function_sibling(array $params, Smarty | Smarty_Internal_Template $Smarty): mixed
{
    $type = 'next';

    if (isset($params['type'])) {
        switch ($params['type']) {
            default:
                $type = 'next';
                break;

            case 'prev':
            case 'previous':
                $type = 'previous';
                break;
        }
    }

    if (!isset($params['site'])) {
        return null;
    }

    try {
        switch ($type) {
            case 'next':
                $Sibling = $params['site']->nextSibling();
                break;

            case 'previous':
                $Sibling = $params['site']->previousSibling();
                break;

            default:
                $Sibling = false;
        }

        $Smarty->assign($params['assign'], $Sibling);
    } catch (Exception) {
        $Smarty->assign($params['assign'], false);
    }

    return null;
}
