<?php

/**
 * Smarty plugin
 *
 * @package    Smarty
 * @subpackage plugins
 */


/**
 * Smarty {site id=site_id var=MySite} function plugin
 *
 * @param array<string, mixed> $params
 * @param Smarty | Smarty_Internal_Template $smarty
 * @return null|string
 * @throws QUI\Exception
 */
function smarty_function_site(array $params, Smarty | Smarty_Internal_Template $smarty): mixed
{
    if (empty($params['id'])) {
        $smarty->assign($params['var'], false);
    }

    if (isset($params['project']) && isset($params['lang'])) {
        $Project = QUI::getProjectManager()->getProject(
            $params['project'],
            $params['lang']
        );
    } elseif (isset($params['project'])) {
        $Project = QUI::getProjectManager()->getProject(
            $params['project']
        );
    } else {
        $Project = QUI::getRewrite()->getProject();
    }

    if (!$Project instanceof QUI\Projects\Project) {
        $Site = false;
    } else {
        try {
            $Site = $Project->get((int)$params['id']);
        } catch (QUI\Exception) {
            $Site = false;
        }
    }

    if (isset($params['attribute'])) {
        if (!$Site) {
            $Site = '';
        } else {
            $Site = $Site->getAttribute($params['attribute']);
        }
    }

    if (!isset($params['var'])) {
        return $Site;
    }

    $smarty->assign($params['var'], $Site);

    return null;
}
