<?php

/**
 * Smarty plugin
 *
 * @package    com.pcsg.pms.smarty
 * @subpackage plugins
 */

use QUI\Exception;
use QUI\Projects\Manager;
use QUI\Projects\Project;

/**
 * Smarty {suffix} function plugin
 *
 * @param array<string, mixed> $params parameters
 * @param Smarty | Smarty_Internal_Template $smarty
 * @return string|null
 * @throws Exception
 */
function smarty_function_suffix(array $params, Smarty | Smarty_Internal_Template $smarty): ?string
{
    global $Project;

    if (!isset($params['suffix'])) {
        return '';
    }

    $P = $Project;

    /* @var $Project Project */

    $url = '';
    $site = false;

    try {
        if (isset($params['site'])) {
            $site = $params['site'];
        } elseif (isset($params['id'])) {
            if (isset($params['lang'])) {
                $P = Manager::getProject(
                    $Project->getAttribute('name'),
                    $params['lang']
                );
            }

            $site = $P->get((int)$params['id']);
        }
    } catch (Exception) {
        return '';
    }

    unset($params['site']);
    unset($params['id']);
    unset($params['lang']);

    $url = '';

    if ($site && $site->getId()) {
        $url = $site->getUrl($params);
    }

    return $url;
}
