<?php

/**
 * Smarty plugin
 *
 * @package    com.pcsg.pms.smarty
 * @subpackage plugins
 */

use QUI\Exception;
use QUI\Smarty\Collector;
use QUI\Template;

/**
 * Smarty {template_event name=""} function plugin
 *
 * @param array<string, mixed> $params
 * @param Smarty | Smarty_Internal_Template $Smarty
 * @return string
 */
function smarty_function_template_event(array $params, Smarty | Smarty_Internal_Template $Smarty): string
{
    if (!isset($params['name'])) {
        return '';
    }

    $Collector = new Collector();
    $Template = null;

    /* @var $Template Template */
    if (isset($params['Template'])) {
        $Template = $params['Template'];
    }

    $name = $params['name'];
    $assign = false;

    if (isset($params['assign'])) {
        $assign = $params['assign'];
    }

    unset($params['name']);
    unset($params['assign']);

    array_unshift($params, $Collector);

    try {
        if ($Template) {
            // add all templates to ignore
            // but not the current
            $packages = QUI::getPackageManager()->searchInstalledPackages([
                'type' => "quiqqer-template"
            ]);

            $TemplatePackage = $Template->getTemplatePackage();
            $tpName = '';

            if ($TemplatePackage) {
                $tpName = $TemplatePackage->getName();
            }

            foreach ($packages as $package) {
                if ($package['name'] !== $tpName) {
                    QUI::getEvents()->ignore($package['name']);
                }
            }
        }

        QUI::getEvents()->fireEvent($name, $params);
        QUI::getEvents()->clearIgnore();
    } catch (QUI\ExceptionStack $Exception) {
        /* @var $e Exception */
        foreach ($Exception->getExceptionList() as $e) {
            QUI\System\Log::addError($e->getMessage(), [
                'trace' => $e->getTraceAsString()
            ]);

            QUI\System\Log::writeDebugException($e);
        }
    } catch (QUI\Exception $e) {
        QUI\System\Log::addError($e->getMessage(), [
            'trace' => $e->getTraceAsString()
        ]);

        QUI\System\Log::writeDebugException($e);
    } catch (Throwable $e) {
        QUI\System\Log::addError($e->getMessage(), [
            'name' => $name,
            'params' => $params,
            'trace' => $e->getTraceAsString()
        ]);
    }

    if (!$assign) {
        return $Collector->getContent();
    }

    $Smarty->assign($assign, $Collector->getContent());

    return '';
}
