<?php

/**
 * Smarty plugin
 *
 * @package    com.pcsg.pms.smarty
 * @subpackage plugins
 */


/**
 * Smarty {url_linked Site= lang=en} function plugin
 *
 * @param array<string, mixed> $params -> GET params = _get__*, useOwnLangLink
 * @param Smarty | Smarty_Internal_Template $smarty
 * @return string
 */
function smarty_function_url_linked(array $params, Smarty | Smarty_Internal_Template $smarty): string
{
    if (!isset($params['Site'])) {
        return '';
    }

    if (!isset($params['lang'])) {
        return '';
    }

    $wantedLang = $params['lang'];
    $useOwnLangLink = false;
    $ownLangLinkParam = $wantedLang . '-link';

    if (isset($params['useOwnLangLink']) && $params['useOwnLangLink']) {
        $useOwnLangLink = true;
    }


    /* @var $Site QUI\Projects\Site */
    $Site = $params['Site'];
    $Project = $Site->getProject();

    if ($Project->getLang() == $wantedLang) {
        if ($useOwnLangLink && $Site->getAttribute($ownLangLinkParam)) {
            return $Site->getAttribute($ownLangLinkParam);
        }

        try {
            return $Site->getUrlRewritten();
        } catch (QUI\Exception $Exception) {
            QUI\System\Log::writeException($Exception);
        }
    }

    try {
        $LangProject = QUI::getProjectManager()->getProject(
            $Project->getName(),
            $wantedLang
        );
    } catch (QUI\Exception) {
        return '';
    }


    try {
        if ($useOwnLangLink && $Site->getAttribute($ownLangLinkParam)) {
            return $Site->getAttribute($ownLangLinkParam);
        }

        $langId = $Site->getId($params['lang']);
        $LangSide = $LangProject->get($langId);

        $Output = QUI::getRewrite()->getOutput();

        return $Output->getSiteUrl([
            'site' => $LangSide
        ]);
    } catch (QUI\Exception) {
    }

    try {
        return $LangProject->firstChild()->getUrlRewritten();
    } catch (QUI\Exception) {
    }

    return '';
}
