/**
 *
 * @module package/quiqqer/template-tailwindcss/bin/Controls/Children/ListPreview.Settings
 *
 * @require qui/controls/elements/FormList
 * @require css!package/quiqqer/template-tailwindcss/bin/Controls/ListPreview.Settings.css
 */
define('package/quiqqer/template-tailwindcss/bin/Controls/Children/ListPreview.Settings', [

    'qui/controls/elements/FormList',
    'utils/Controls',
    'Locale',
    'Mustache',

    'text!package/quiqqer/template-tailwindcss/bin/Controls/Children/ListPreview.Settings.html',
    'css!package/quiqqer/template-tailwindcss/bin/Controls/Children/ListPreview.Settings.css'

], function (QUIFormList, QUIControls, QUILocale, Mustache, template) {
    "use strict";

    var lg = 'quiqqer/template-tailwindcss';

    return new Class({

        Extends: QUIFormList,
        Type   : 'package/quiqqer/template-tailwindcss/bin/Controls/Children/ListPreview.Settings',

        Binds: [
            '$onParsed'
        ],

        initialize: function (options) {
            this.parent(options);

            this.$Project = null;

            this.addEvents({
                onParsed: this.$onParsed
            });

            this.getElm().addClass('qui-controls-formlist-listPreview');

            this.setAttributes({
                buttonText: QUILocale.get(lg, 'brick.listPreview.setting.entry.add'),
                entry     : Mustache.render(template, {
                    'entryImage'         : QUILocale.get(lg, 'brick.listPreview.setting.entry.image'),
                    'entryTitle'         : QUILocale.get(lg, 'brick.listPreview.setting.entry.title'),
                    'entryShortDesc'     : QUILocale.get(lg, 'brick.listPreview.setting.entry.shortDesc'),
                    'entryUrl'           : QUILocale.get(lg, 'brick.listPreview.setting.entry.url'),
                    'entryUrlPlaceholder': QUILocale.get(lg, 'brick.listPreview.setting.entry.url.placeholder'),
                    'entryPriority'         : QUILocale.get(lg, 'brick.listPreview.setting.entry.priority'),
                    'entryLongDesc'       : QUILocale.get(lg, 'brick.listPreview.setting.entry.longDesc')
                })
            });
        },

        /**
         * set the project to the control
         *
         * @param Project
         */
        setProject: function (Project) {
            this.$Project = Project;
            this.$onParsed(false, this.getElm());
        },

        /**
         * Parses QUI controls when a new entry is created
         *
         * Fired after (inherited) FormList has parsed the content
         *
         * @param event
         * @param Node - The element that was previously parsed by (inherited) FormList
         */
        $onParsed: function (event, Node) {
            if (!this.$Project) {
                return;
            }

            new Element('div', {
                'class': 'qui-controls-formlist-listPreview-placeholderBox'
            }).inject(this.getElm().getElement('.qui-controls-formlist-container'));

            this.$executeParsing(Node);
        },

        /**
         * Parse the editor
         *
         * @param Node
         * @returns {Promise}
         */
        $executeParsing: function (Node) {
            var self = this;

            return QUIControls.parse(Node).then(function () {
                // Element is fully parsed so we can finally show it
                Node.getElements('.quiqqer-tailwindcss-listPreview-entry').show();

                self.getElm().addClass('qui-controls-formlist-listPreview');

                var inputEditors = Node.getElements('[data-qui="controls/editors/Input"]').map(function (InnerNode) {
                    return QUI.Controls.getById(InnerNode.get('data-quiid'));
                });

                for (var i = 0, len = inputEditors.length; i < len; i++) {
                    inputEditors[i].setProject(self.$Project);
                }
            });
        }
    });
});

