![QUIQQER Verification](bin/images/Readme.jpg)

QUIQQER Verification
========

Verify any action via a special url with a unique hash (i.e. user registration, newsletter opt-in etc.)

Paketname:

    quiqqer/verification


Features
--------

* Create custom Verification classes that handle your verification process(es)
* By starting a Verification you create a unique URL that you can send to the user
* If the user clicks the URL, your Verification class is called
* Each Verification can show a custom message on succes or on error
  * Alternatively you can create redirects to sites of your choosing on success or on error
* Verifications are identified by a unique ID and a unique hash 
* Supports **three** verification types:
  * **Verification via link** - Create a special link and a handler that is called if this link is opened
  * **Verification via phone (SMS / Call)** - Send a verification code to a phone number via call or SMS, verify the code and handle it with your custom handler
    * requires [quiqqer/phone-api](https://dev.quiqqer.com/quiqqer/phone-api) and a phone API provider (e.g. [quiqqer/phone-api-client-seven](https://dev.quiqqer.com/quiqqer/phone-api-client-seven))
  * **Verification via letter** - Send a verification code to an address via letter, verify the code and handle it with your custom handler
    * requires a way to send letters; e.g.: [quiqqer/letter-dispatch](https://dev.quiqqer.com/quiqqer/letter-dispatch) and a letter API provider (e.g. [quiqqer/letter-dispatch-client-ebrief](https://dev.quiqqer.com/quiqqer/letter-dispatch-client-ebrief))
Installation
------------

Package name: quiqqer/verification


Collaboration
----------

- Issue Tracker: https://dev.quiqqer.com/quiqqer/verification/issues
- Source Code: https://dev.quiqqer.com/quiqqer/verification


Support
-------

If you found any flaws, have any wishes or suggestions you can send an email to support@pcsg.de to inform us about your concerns. 
We will try to respond to your request and forward it to the responsible developer.


License
-------
PCSG QL-1.0, CC BY-NC-SA 4.0

Usage
--------

### 1. Prepare your project for verification processes
Create a site in your project with site type `QUIQQER - Verifier`. This is the site that the user will be directed to when he verifies a process.

### 2. Create your handler class
```php
<?php

use QUI\Verification\Interface\LinkVerificationHandlerInterface;
use QUI\Verification\Interface\PhoneNumberVerificationHandlerInterface;
use QUI\Verification\Interface\AddressVerificationHandlerInterface;

class MyLinkVerificationHandler implements LinkVerificationHandlerInterface
{
  // Implement the interface
}

class MyPhoneNumberVerificationHandler implements PhoneNumberVerificationHandlerInterface
{
  // Implement the interface
}

class MyAddressVerificationHandler implements AddressVerificationHandlerInterface
{
  // Implement the interface
}
```

### 3. Create a verification process
```php
<?php
use QUI\Verification\VerificationFactory;
use QUI\Verification\Enum\PhoneNumberVerificationStrategy;
use QUI\Verification\Verifier;
use QUI\Verification\VerificationRepository;

$factory = new VerificationFactory();

// Link verification
$linkVerification = $factory->createLinkVerification(
    'my-custom-identifier', // use any string that uniquely identifies your verification process
    new MyLinkVerificationHandler(),
    [
        'customData' => 'my custom data' // customer data is available in the verification that is returned
    ],
    false // overwrite existing verifications with the same identifier if it already exists; otherwise an exception is thrown if the verification with the same identifier already exists
);

$url = $linkVerification->getVerificationUrl();

// If this special URL is called, an instance of MyLinkVerificationHandler will be called
// Depending on if the hash is valid and the verification process is not expired, onSuccess() or onError() will be called

// Phone number verification
$phoneNumberVerification = $factory->createPhoneNumberVerification(
    'my-custom-identifier',
    new \QUI\PhoneApi\Entity\PhoneNumber('+49123456789'), // entity class can be found in quiqqer/phone-api
    PhoneNumberVerificationStrategy::CALL, // or ::SMS
    new MyPhoneNumberVerificationHandler(),
    [
        'customData' => 'my custom data'
    ],
    'ABC123' // Optional: You can provide a specific verification code; if omitted, a random one will be generated
);

// The user gets a call or SMS with a verification code
// You have to build a form where this code can be entered
// Then you fetch the verification instance by identifier depending on the context; e.g.:

$verificationRepository = new VerificationRepository();
$phoneNumberVerification = $verificationRepository->findByIdentifier('my-custom-identifier');

// The code can be verified in the following way:
$verifier = new Verifier();

// This will verify the code, call an instance of MyPhoneNumberVerificationHandler and additionally throw an exception on any kind of verification error (which you can just catch and ignore if you want your handler to handle everything)
$verifier->verifyPhoneNumberVerification($phoneNumberVerification, 'code_entered_by_user');

// Address verification
$addressVerification = $factory->createAddressVerification(
    'my-custom-identifier',
    new \QUI\Verification\Entity\Address('John Doe', 'My Street', '2B', '12345', 'My City', 'DE'),
    new MyAddressVerificationHandler(),
    [
        'customData' => 'my custom data'
    ],
    'ABC123' // Optional: You can provide a specific verification code; if omitted, a random one will be generated
);

// Send the letter (e.g. with quiqqer/letter-dispatch)

// The verification process is identical to the phone number
$verifier->verifyAddressVerification($addressVerification, 'code_entered_by_user');
```