<?php

namespace QUI\Verification;

use QUI\Verification\Entity\LinkVerification;
use QUI\Verification\Enum\VerificationErrorReason;
use QUI\Verification\Interface\LinkVerificationHandlerInterface;
use QUI\Verification\Entity\AbstractVerification;

abstract class AbstractLinkVerificationHandler implements LinkVerificationHandlerInterface
{
    /**
     * Get the duration of a Verification (minutes)
     *
     * @param AbstractVerification $verification
     * @return int|null - duration in minutes;
     * on NULL use the module setting default value
     */
    public function getValidDuration(AbstractVerification $verification): ?int
    {
        return null;
    }

    /**
     * Automatically redirect the user to this URL on successful verification
     *
     * @param LinkVerification $verification
     * @return string|null - on NULL, no redirection takes place
     */
    public function getOnSuccessRedirectUrl(LinkVerification $verification): ?string
    {
        return null;
    }

    /**
     * Automatically redirect the user to this URL on unsuccessful verification
     *
     * @param LinkVerification $verification
     * @param VerificationErrorReason $reason
     * @return string|null - on NULL, no redirection takes place
     */
    public function getOnErrorRedirectUrl(LinkVerification $verification, VerificationErrorReason $reason): ?string
    {
        return null;
    }
}
