<?php

namespace QUI\Verification\Entity;

use DateTimeImmutable;
use QUI\Verification\Enum\VerificationStatus;

abstract class AbstractVerification
{
    /**
     * @param string $uuid
     * @param string $identifier
     * @param string $verificationCode
     * @param DateTimeImmutable $createDate
     * @param DateTimeImmutable $updateDate
     * @param int $tries
     * @param VerificationStatus $status
     * @param array<string|int,mixed> $customData
     * @param DateTimeImmutable|null $validUntilDate
     */
    public function __construct(
        public readonly string $uuid,
        public readonly string $identifier,
        public readonly string $verificationCode,
        public readonly DateTimeImmutable $createDate,
        public readonly DateTimeImmutable $updateDate,
        public int $tries,
        public VerificationStatus $status = VerificationStatus::PENDING,
        public array $customData = [],
        public ?DateTimeImmutable $validUntilDate = null
    ) {
    }

    /**
     * @return array<string|int,mixed>
     */
    public function getCustomData(): array
    {
        return $this->customData;
    }

    /**
     * @param string $key
     * @return mixed|null
     */
    public function getCustomDataEntry(string $key): mixed
    {
        return $this->customData[$key] ?? null;
    }

    public function isValid(): bool
    {
        if (is_null($this->validUntilDate)) {
            return true;
        }

        return $this->validUntilDate > new DateTimeImmutable();
    }

    /**
     * @param array<string,mixed> $data
     * @return static
     */
    abstract public static function fromArray(array $data): static;

    /**
     * Get type (class name)
     *
     * @return string
     */
    public static function getType(): string
    {
        return get_called_class();
    }
}
