<?php

namespace QUI\Verification\Entity;

use QUI;

use function dirname;

final class Address
{
    public function __construct(
        public string $name,
        public string $street,
        public string $houseNumber,
        public string $zipCode,
        public string $city,
        public string $countryCode,
        public ?string $salutation = null,
        public ?string $company = null
    ) {
    }

    /**
     * @return array<string,string|null>
     */
    public function toArray(): array
    {
        return [
            'name' => $this->name,
            'street' => $this->street,
            'houseNumber' => $this->houseNumber,
            'zipCode' => $this->zipCode,
            'city' => $this->city,
            'countryCode' => $this->countryCode,
            'salutation' => $this->salutation,
            'company' => $this->company
        ];
    }

    /**
     * Return the address as HTML display
     *
     * @return string - HTML <address>
     */
    public function getDisplay(): string
    {
        $Engine = QUI::getTemplateManager()->getEngine(true);
        $Engine->assign($this->toArray());

        return $Engine->fetch(dirname(__FILE__) . '/Address.html');
    }

    /**
     * @param array<string,string> $data
     * @return Address
     */
    public static function fromArray(array $data): Address
    {
        return new Address(
            $data['name'],
            $data['street'],
            $data['houseNumber'],
            $data['zipCode'],
            $data['city'],
            $data['countryCode'],
            $data['salutation'] ?? null,
            $data['company'] ?? null
        );
    }
}
