<?php

namespace QUI\Verification\Entity;

use DateTimeImmutable;
use QUI\Verification\Enum\VerificationStatus;

class AddressVerification extends AbstractVerification
{
    /**
     * @param string $uuid
     * @param string $identifier
     * @param string $verificationCode
     * @param DateTimeImmutable $createDate
     * @param DateTimeImmutable $updateDate
     * @param int $tries
     * @param Address $address
     * @param VerificationStatus $status
     * @param array<string|int,mixed> $customData
     * @param DateTimeImmutable|null $validUntilDate
     */
    public function __construct(
        string $uuid,
        string $identifier,
        string $verificationCode,
        DateTimeImmutable $createDate,
        DateTimeImmutable $updateDate,
        int $tries,
        public readonly Address $address,
        public readonly string $verificationUrl,
        VerificationStatus $status = VerificationStatus::PENDING,
        array $customData = [],
        ?DateTimeImmutable $validUntilDate = null
    ) {
        $customData['address'] = $address->toArray();
        $customData['verificationUrl'] = $verificationUrl;

        parent::__construct(
            $uuid,
            $identifier,
            $verificationCode,
            $createDate,
            $updateDate,
            $tries,
            $status,
            $customData,
            $validUntilDate
        );
    }

    /**
     * @param array<string,mixed> $data
     * @return static
     *
     * @throws \DateMalformedStringException
     */
    public static function fromArray(array $data): static
    {
        $data['customData']['strategy'] = 'sms';
        return new AddressVerification(
            $data['uuid'],
            $data['identifier'],
            $data['verificationCode'],
            new DateTimeImmutable($data['createDate']),
            new DateTimeImmutable($data['updateDate']),
            (int)$data['tries'],
            Address::fromArray($data['customData']['address']),
            $data['customData']['verificationUrl'],
            VerificationStatus::from($data['status']),
            $data['customData'],
            !empty($data['validUntilDate']) ? new DateTimeImmutable($data['validUntilDate']) : null
        );
    }
}
