<?php

namespace QUI\Verification\Entity;

use DateTimeImmutable;
use QUI\Verification\Enum\VerificationStatus;

class LinkVerification extends AbstractVerification
{
    /**
     * @param string $uuid
     * @param string $identifier
     * @param string $verificationCode
     * @param DateTimeImmutable $createDate
     * @param DateTimeImmutable $updateDate
     * @param int $tries
     * @param string $verificationUrl
     * @param VerificationStatus $status
     * @param array<string|int,mixed> $customData
     * @param DateTimeImmutable|null $validUntilDate
     */
    public function __construct(
        string $uuid,
        string $identifier,
        string $verificationCode,
        DateTimeImmutable $createDate,
        DateTimeImmutable $updateDate,
        int $tries,
        string $verificationUrl,
        VerificationStatus $status = VerificationStatus::PENDING,
        array $customData = [],
        ?DateTimeImmutable $validUntilDate = null
    ) {
        $customData['verificationUrl'] = $verificationUrl;
        parent::__construct(
            $uuid,
            $identifier,
            $verificationCode,
            $createDate,
            $updateDate,
            $tries,
            $status,
            $customData,
            $validUntilDate
        );
    }

    /**
     * @param array<string,mixed> $data
     * @return static
     * @throws \DateMalformedStringException
     */
    public static function fromArray(array $data): static
    {
        return new LinkVerification(
            $data['uuid'],
            $data['identifier'],
            $data['verificationCode'],
            new DateTimeImmutable($data['createDate']),
            new DateTimeImmutable($data['updateDate']),
            (int)$data['tries'],
            $data['customData']['verificationUrl'],
            VerificationStatus::from($data['status']),
            $data['customData'],
            !empty($data['validUntilDate']) ? new DateTimeImmutable($data['validUntilDate']) : null
        );
    }

    public function getVerificationUrl(): string
    {
        return $this->getCustomDataEntry('verificationUrl');
    }
}
