<?php

namespace QUI\Verification\Entity;

use DateTimeImmutable;
use QUI\PhoneApi\Entity\PhoneNumber;
use QUI\Verification\Enum\PhoneNumberVerificationStrategy;
use QUI\Verification\Enum\VerificationStatus;

class PhoneNumberVerification extends AbstractVerification
{
    /**
     * @param string $uuid
     * @param string $identifier
     * @param string $verificationCode
     * @param DateTimeImmutable $createDate
     * @param DateTimeImmutable $updateDate
     * @param int $tries
     * @param PhoneNumber $phoneNumber
     * @param PhoneNumberVerificationStrategy $strategy
     * @param VerificationStatus $status
     * @param array<string|int,mixed> $customData
     * @param DateTimeImmutable|null $validUntilDate
     */
    public function __construct(
        string $uuid,
        string $identifier,
        string $verificationCode,
        DateTimeImmutable $createDate,
        DateTimeImmutable $updateDate,
        int $tries,
        public readonly PhoneNumber $phoneNumber,
        PhoneNumberVerificationStrategy $strategy,
        VerificationStatus $status = VerificationStatus::PENDING,
        array $customData = [],
        ?DateTimeImmutable $validUntilDate = null
    ) {
        $customData['phoneNumber'] = $phoneNumber->asE164();
        $customData['strategy'] = $strategy->value;

        parent::__construct(
            $uuid,
            $identifier,
            $verificationCode,
            $createDate,
            $updateDate,
            $tries,
            $status,
            $customData,
            $validUntilDate
        );
    }

    /**
     * @param array<string,mixed> $data
     * @return static
     *
     * @throws \DateMalformedStringException
     * @throws \libphonenumber\NumberParseException
     */
    public static function fromArray(array $data): static
    {
        $data['customData']['strategy'] = 'sms';
        return new PhoneNumberVerification(
            $data['uuid'],
            $data['identifier'],
            $data['verificationCode'],
            new DateTimeImmutable($data['createDate']),
            new DateTimeImmutable($data['updateDate']),
            (int)$data['tries'],
            new PhoneNumber($data['customData']['phoneNumber']),
            PhoneNumberVerificationStrategy::from($data['customData']['strategy']),
            VerificationStatus::from($data['status']),
            $data['customData'],
            !empty($data['validUntilDate']) ? new DateTimeImmutable($data['validUntilDate']) : null
        );
    }
}
