<?php

namespace QUI\Verification\Exception;

use DateTimeImmutable;
use QUI\Verification\Exception;

/**
 * Thrown if an expired verification cannot be created due to cooldown restrictions.
 */
class VerificationCooldownActiveException extends Exception
{
    /**
     * @param DateTimeImmutable $cooldownExpirationDate
     * @param string|null $message
     * @param int $code
     * @param array<string,mixed> $context
     */
    public function __construct(
        public readonly DateTimeImmutable $cooldownExpirationDate,
        ?string $message = null,
        int $code = 0,
        array $context = []
    ) {
        parent::__construct($message, $code, $context);
    }
}
