<?php

namespace QUI\Verification\Interface;

use QUI\Verification\Entity\AddressVerification;
use QUI\Verification\Enum\VerificationErrorReason;

interface AddressVerificationHandlerInterface extends VerificationHandlerInterface
{
    /**
     * Execute this method on successful verification
     *
     * @param AddressVerification $verification
     * @return void
     */
    public function onSuccess(AddressVerification $verification): void;

    /**
     * Execute this method on unsuccessful verification
     *
     * @param AddressVerification $verification
     * @param VerificationErrorReason $reason
     * @return void
     */
    public function onError(AddressVerification $verification, VerificationErrorReason $reason): void;

    /**
     * Automatically redirect the user to this URL on successful verification
     *
     * @param AddressVerification $verification
     * @return string|null - on NULL, no redirection takes place
     */
    public function getOnSuccessRedirectUrl(AddressVerification $verification): ?string;
}
