<?php

namespace QUI\Verification\Interface;

use QUI\Verification\Entity\PhoneNumberVerification;
use QUI\Verification\Enum\VerificationErrorReason;

interface PhoneNumberVerificationHandlerInterface extends VerificationHandlerInterface
{
    /**
     * Execute this method on successful verification
     *
     * @param PhoneNumberVerification $verification
     * @return void
     */
    public function onSuccess(PhoneNumberVerification $verification): void;

    /**
     * Execute this method on unsuccessful verification
     *
     * @param PhoneNumberVerification $verification
     * @param VerificationErrorReason $reason
     * @return void
     */
    public function onError(PhoneNumberVerification $verification, VerificationErrorReason $reason): void;
}
