<?php

namespace QUI\Verification\Interface;

use QUI\Verification\Entity\AbstractVerification;
use QUI\Verification\Enum\VerificationErrorReason;

/**
 * Handler that processes verifications via link.
 */
interface VerificationHandlerInterface
{
    /**
     * Get the duration of a Verification (minutes)
     *
     * @param AbstractVerification $verification
     * @return int|null - duration in minutes;
     * on NULL use the module setting default value
     */
    public function getValidDuration(AbstractVerification $verification): ?int;
}
