<?php

namespace QUI\Verification\Interface;

use QUI\Verification\Entity\AbstractVerification;
use QUI\Verification\Enum\VerificationStatus;

interface VerificationRepositoryInterface
{
    /**
     * @param string $uuid
     * @return AbstractVerification|null
     */
    public function findByUuid(string $uuid): ?AbstractVerification;

    public function findByIdentifier(string $identifier): ?AbstractVerification;

    /**
     * @param AbstractVerification $verification
     * @param VerificationHandlerInterface $verificationHandler
     * @return void
     */
    public function insert(AbstractVerification $verification, VerificationHandlerInterface $verificationHandler): void;

    /**
     * @param AbstractVerification $verification
     * @return void
     */
    public function update(AbstractVerification $verification): void;

    /**
     * @param AbstractVerification $verification
     * @return void
     */
    public function delete(AbstractVerification $verification): void;

    /**
     * Get instance of the verification handler for a verification.
     *
     * @param AbstractVerification $verification
     * @return VerificationHandlerInterface
     * @throws \Doctrine\DBAL\Exception
     */
    public function getVerificationHandler(AbstractVerification $verification): VerificationHandlerInterface;

    /**
     * Finds all verifications that are unverified (pending) and exceeded their validity date.
     *
     * @return AbstractVerification[]
     */
    public function findAllUnverifiedAndInvalid(): array;

    /**
     * @param VerificationStatus $status
     * @return AbstractVerification[]
     */
    public function findAllByStatus(VerificationStatus $status): array;
}
