<?php

namespace QUI\Verification\Interface;

use QUI\Verification\Entity\AbstractVerification;
use QUI\Verification\Entity\PhoneNumberVerification;
use QUI\Verification\Entity\AddressVerification;

interface VerifierInterface
{
    /**
     * Verify a phone number.
     *
     * @param PhoneNumberVerification $verification
     * @param string $verificationCode
     * @return void
     */
    public function verifyPhoneNumberVerification(
        PhoneNumberVerification $verification,
        string $verificationCode
    ): void;

    /**
     * Check the verification code of a verification.
     *
     * @param AbstractVerification $verification
     * @param string $verificationCode
     * @return void
     */
    public function verifyVerificationCode(AbstractVerification $verification, string $verificationCode): void;

    /**
     * @param AddressVerification $verification
     * @param string $verificationCode
     * @return void
     */
    public function verifyAddressVerification(AddressVerification $verification, string $verificationCode): void;
}
