<?php

namespace QUI\Verification;

use QUI;

use function is_null;

class Settings
{
    private static ?QUI\Config $config = null;

    /**
     * @param string $key
     * @return string
     * @throws QUI\Exception
     */
    public static function get(string $key): string
    {
        return self::getConfig()->get('settings', $key);
    }

    /**
     * @return QUI\Config
     * @throws QUI\Exception
     */
    private static function getConfig(): QUI\Config
    {
        if (is_null(self::$config)) {
            self::$config = QUI::getPackage('quiqqer/verification')->getConfig();

            if (is_null(self::$config)) {
                throw new QUI\Exception("Cannot load config of package 'quiqqer/verification'");
            }
        }

        return self::$config;
    }
}
