<?php

namespace QUI\Verification;

use QUI\Verification\Interface\VerificationCodeFactoryInterface;

use function md5;
use function openssl_random_pseudo_bytes;

class VerificationCodeFactory implements VerificationCodeFactoryInterface
{
    public function createRandomHashCode(): string
    {
        return md5(openssl_random_pseudo_bytes(256));
    }

    /**
     * @param int $length
     * @return string
     * @throws \Random\RandomException
     */
    public function createRandomDigitsCode(int $length = 6): string
    {
        $code = '';

        for ($i = 0; $i < $length; $i++) {
            $code .= random_int(0, 9);
        }

        return $code;
    }
}
