<?php

namespace QUI\Verification\Verifier;

use QUI\Exception;
use QUI\PhoneApi\Interface\PhoneApiClientInterface;
use QUI\PhoneApi\ProviderManager;

use function is_null;

abstract class AbstractPhoneVerifier
{
    /**
     * @param PhoneApiClientInterface|null $phoneApiClient
     * @throws Exception
     */
    public function __construct(
        protected ?PhoneApiClientInterface $phoneApiClient = null // @phpstan-ignore-line
    ) {
        if (is_null($this->phoneApiClient) && class_exists('QUI\PhoneApi\ProviderManager')) {
            $phoneApiProviderManager = new ProviderManager();
            $this->phoneApiClient = $phoneApiProviderManager->getCurrentPhoneApiClient();
        }
    }
}
