<?php

namespace QUI\Verification\Verifier;

use QUI;
use QUI\PhoneApi\Entity\SMS;
use QUI\Verification\Entity\PhoneNumberVerification;

class PhoneNumberViaSmsPhoneVerifier extends AbstractPhoneVerifier
{
    /**
     * @param PhoneNumberVerification $verification
     * @param string|null $smsText (optional) - If omitted use default text provided by locale
     * [quiqqer/verificaion] PhoneNumberViaSmsVerifier.sms_text
     * @return void
     */
    public function startVerification(PhoneNumberVerification $verification, ?string $smsText = null): void
    {
        if (!class_exists('QUI\PhoneApi\Entity\SMS')) {
            return;
        }

        $sms = new SMS(
            $verification->phoneNumber,
            $smsText ?: QUI::getLocale()->get(
                'quiqqer/verificaion',
                'PhoneNumberViaSmsVerifier.sms_text',
                [
                    'code' => $verification->verificationCode
                ]
            )
        );

        // @phpstan-ignore-next-line
        $this->phoneApiClient->sendSMS($sms);
    }
}
