<?php

namespace QUI\Verification\Verifier;

use QUI;
use QUI\PhoneApi\Entity\VoiceCall;
use QUI\Verification\Entity\PhoneNumberVerification;

class PhoneNumberViaVoiceCallPhoneVerifier extends AbstractPhoneVerifier
{
    /**
     * @param PhoneNumberVerification $verification
     * @param string|null $speechText (optional) - If omitted use default text provided by locale
     * [quiqqer/verificaion] PhoneNumberViaVoiceCallVerifier.sms_text
     * @return void
     */
    public function startVerification(PhoneNumberVerification $verification, ?string $speechText = null): void
    {
        if (!class_exists('QUI\PhoneApi\Entity\VoiceCall')) {
            return;
        }

        $voiceCall = new VoiceCall(
            $verification->phoneNumber,
            $speechText ?: QUI::getLocale()->get(
                'quiqqer/verificaion',
                'PhoneNumberViaVoiceCallVerifier.speech_text',
                [
                    'code' => $verification->verificationCode
                ]
            )
        );

        $this->phoneApiClient->sendCall($voiceCall); // @phpstan-ignore-line
    }
}
