<?php

/**
 * global params
 *
 * @var QUI\Projects\Project $Project
 * @var QUI\Projects\Site $Site
 * @var QUI\Interfaces\Template\EngineInterface $Engine
 * @var QUI\Template $Template
 **/

use QUI\Permissions\Exception as QUIPermissionException;
use QUI\Verification\Controls\AddressVerification;
use QUI\Verification\Exception as VerificationException;

/**
 * @param string $target
 * @return never
 */
function redirect(string $target): never
{
    header('Location: ' . $target);
    exit;
}

$User = QUI::getUserBySession();

$isLoginRequired = boolval($Site->getAttribute('quiqqer.verification.address.require_login'));

// If user must be authenticated and is not -> throw permission exception so QUIQQER shows the login form
if ($isLoginRequired && !QUI::getUsers()->isAuth($User)) {
    throw new QUIPermissionException("Please authenticate.", 401);
}

if (empty($_GET['id'])) {
    redirect('/');
}

$errorMsg = null;

try {
    $addressVerification = new AddressVerification($_GET['id']);
} catch (VerificationException $exception) {
    QUI\System\Log::writeDebugException($exception);

    $errorMsg = QUI::getLocale()->get(
        'quiqqer/verification',
        'message.types.verifyAddress.error.general'
    );
} catch (\Throwable $exception) {
    QUI\System\Log::writeException($exception);

    $errorMsg = QUI::getLocale()->get(
        'quiqqer/verification',
        'message.types.verifyAddress.error.general'
    );
}

$Engine->assign([
    'errorMsg' => $errorMsg,
    'addressVerificationControl' => $addressVerification ?? null
]);
